(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    157259,       3567]
NotebookOptionsPosition[    147358,       3414]
NotebookOutlinePosition[    147751,       3430]
CellTagsIndexPosition[    147708,       3427]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"2e115df6-5abc-46e8-8d92-26eb4951c1d9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"18854a9a-c2dc-437f-98a8-b8870d304360"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669683052359133`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"a07d32c7-b03c-4295-b65f-2c7e252a2308"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.966968305236465*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"f9aa7dfc-dd50-4ddb-ae89-f1255688b84c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305236766*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"3cd2bebd-0081-44ad-9a95-a04db536caa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237047*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"04f28e80-f432-4c69-9c54-c0af55a45223"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237317*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"bbf5d659-2afa-47bf-987a-02a5bcb0148f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237576*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"d7b44d30-dbe3-49a5-88a7-83697a28f79b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. SISTEMA COMPILADOR TEX", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, {
   3.966430546956641*^9, 3.96643054737173*^9}, 3.966430633856382*^9, {
   3.966445464330411*^9, 3.966445470260504*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"011f5e53-d3a6-4662-8d47-8ee4606d5bb9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SistemaCompilador"}]], "Input",
 CellChangeTimes->{{3.966523000456559*^9, 3.9665230045067596`*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"405796b3-fb47-4472-b414-181c47bafa4a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SistemaCompilador es un conjunto completo de \
funciones para la detecci\[OAcute]n autom\[AAcute]tica, gesti\[OAcute]n y \
compilaci\[OAcute]n de documentos LaTeX en Wolfram Mathematica. Detecta autom\
\[AAcute]ticamente editores LaTeX instalados y compila documentos a \
PDF.\\n\\n=== FUNCIONES PRINCIPALES ===\\n\\n\[Bullet] \
DetectLaTeXEditorsPattern[]    Detecta autom\[AAcute]ticamente editores LaTeX \
instalados en el sistema (TeXShop, TeXstudio, TeXmaker, Texifier, LaTeXiT, \
TeXworks, VS Code). Compatible con macOS, Windows y Unix.\\n\\n\[Bullet] \
ShowAvailableEditors[] Muestra una lista de todos los editores LaTeX \
detectados con sus ubicaciones.    Ejecuta detecci\[OAcute]n \
autom\[AAcute]tica si no se han detectado editores \
previamente.\\n\\n\[Bullet] RefreshEditors[] Fuerza una nueva \
detecci\[OAcute]n de editores LaTeX, \[UAcute]til despu\[EAcute]s de instalar \
nuevos editores. Limpia la cache y vuelve a escanear el sistema.\\n\\n\
\[Bullet] CompiladorTex[filePath, opts] Funci\[OAcute]n principal del \
sistema. Abre un archivo LaTeX en el editor especificado y lo compila autom\
\[AAcute]ticamente a PDF usando pdflatex. Opciones: \\\"PreferredEditor\\\" \
-> \\\"NombreEditor\\\" | Automatic\\n\\n=== VARIABLES DEL SISTEMA ===\\n\\n\
\[Bullet] $LaTeXEditors    Variable global que almacena los editores \
detectados como asociaci\[OAcute]n. Se actualiza autom\[AAcute]ticamente \
durante la detecci\[OAcute]n.\\n\\n=== CARACTER\[CapitalIAcute]STICAS ===\\n- \
Detecci\[OAcute]n autom\[AAcute]tica multiplataforma (macOS/Windows/Unix)\\n- \
B\[UAcute]squeda inteligente de pdflatex en ubicaciones est\[AAcute]ndar y \
PATH del sistema\\n- Apertura autom\[AAcute]tica del PDF generado en el visor \
apropiado\\n- Manejo robusto de errores con mensajes informativos\\n- B\
\[UAcute]squeda flexible de editores (case-insensitive, coincidencia parcial)\
\\n- Compatible con las principales distribuciones LaTeX (MacTeX, MiKTeX, \
TeXLive)\\n\\n=== EJEMPLO DE USO ===\\nShowAvailableEditors[]  (* Ver \
editores disponibles *) \\nCompiladorTex[\\\"documento.tex\\\", \
\\\"PreferredEditor\\\" -> \\\"TeXstudio\\\"]\\nRefreshEditors[]  (* Si \
instalas un nuevo editor *)\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`SistemaCompilador\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SistemaCompilador es un conjunto completo de \
funciones para la detecci\[OAcute]n autom\[AAcute]tica, gesti\[OAcute]n y \
compilaci\[OAcute]n de documentos LaTeX en Wolfram Mathematica. Detecta autom\
\[AAcute]ticamente editores LaTeX instalados y compila documentos a \
PDF.\\n\\n=== FUNCIONES PRINCIPALES ===\\n\\n\[Bullet] \
DetectLaTeXEditorsPattern[]    Detecta autom\[AAcute]ticamente editores LaTeX \
instalados en el sistema (TeXShop, TeXstudio, TeXmaker, Texifier, LaTeXiT, \
TeXworks, VS Code). Compatible con macOS, Windows y Unix.\\n\\n\[Bullet] \
ShowAvailableEditors[] Muestra una lista de todos los editores LaTeX \
detectados con sus ubicaciones.    Ejecuta detecci\[OAcute]n \
autom\[AAcute]tica si no se han detectado editores \
previamente.\\n\\n\[Bullet] RefreshEditors[] Fuerza una nueva \
detecci\[OAcute]n de editores LaTeX, \[UAcute]til despu\[EAcute]s de instalar \
nuevos editores. Limpia la cache y vuelve a escanear el sistema.\\n\\n\
\[Bullet] CompiladorTex[filePath, opts] Funci\[OAcute]n principal del \
sistema. Abre un archivo LaTeX en el editor especificado y lo compila autom\
\[AAcute]ticamente a PDF usando pdflatex. Opciones: \\\"PreferredEditor\\\" \
-> \\\"NombreEditor\\\" | Automatic\\n\\n=== VARIABLES DEL SISTEMA ===\\n\\n\
\[Bullet] $LaTeXEditors    Variable global que almacena los editores \
detectados como asociaci\[OAcute]n. Se actualiza autom\[AAcute]ticamente \
durante la detecci\[OAcute]n.\\n\\n=== CARACTER\[CapitalIAcute]STICAS ===\\n- \
Detecci\[OAcute]n autom\[AAcute]tica multiplataforma (macOS/Windows/Unix)\\n- \
B\[UAcute]squeda inteligente de pdflatex en ubicaciones est\[AAcute]ndar y \
PATH del sistema\\n- Apertura autom\[AAcute]tica del PDF generado en el visor \
apropiado\\n- Manejo robusto de errores con mensajes informativos\\n- B\
\[UAcute]squeda flexible de editores (case-insensitive, coincidencia parcial)\
\\n- Compatible con las principales distribuciones LaTeX (MacTeX, MiKTeX, \
TeXLive)\\n\\n=== EJEMPLO DE USO ===\\nShowAvailableEditors[]  (* Ver \
editores disponibles *) \\nCompiladorTex[\\\"documento.tex\\\", \
\\\"PreferredEditor\\\" -> \\\"TeXstudio\\\"]\\nRefreshEditors[]  (* Si \
instalas un nuevo editor *)\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "SistemaCompilador es un conjunto completo de funciones para la detecci\
\[OAcute]n autom\[AAcute]tica, gesti\[OAcute]n y compilaci\[OAcute]n de \
documentos LaTeX en Wolfram Mathematica. Detecta autom\[AAcute]ticamente \
editores LaTeX instalados y compila documentos a PDF.\n\n=== FUNCIONES \
PRINCIPALES ===\n\n\[Bullet] DetectLaTeXEditorsPattern[]    Detecta autom\
\[AAcute]ticamente editores LaTeX instalados en el sistema (TeXShop, \
TeXstudio, TeXmaker, Texifier, LaTeXiT, TeXworks, VS Code). Compatible con \
macOS, Windows y Unix.\n\n\[Bullet] ShowAvailableEditors[] Muestra una lista \
de todos los editores LaTeX detectados con sus ubicaciones.    Ejecuta \
detecci\[OAcute]n autom\[AAcute]tica si no se han detectado editores \
previamente.\n\n\[Bullet] RefreshEditors[] Fuerza una nueva detecci\[OAcute]n \
de editores LaTeX, \[UAcute]til despu\[EAcute]s de instalar nuevos editores. \
Limpia la cache y vuelve a escanear el sistema.\n\n\[Bullet] \
CompiladorTex[filePath, opts] Funci\[OAcute]n principal del sistema. Abre un \
archivo LaTeX en el editor especificado y lo compila autom\[AAcute]ticamente \
a PDF usando pdflatex. Opciones: \"PreferredEditor\" -> \"NombreEditor\" | \
Automatic\n\n=== VARIABLES DEL SISTEMA ===\n\n\[Bullet] $LaTeXEditors    \
Variable global que almacena los editores detectados como asociaci\[OAcute]n. \
Se actualiza autom\[AAcute]ticamente durante la detecci\[OAcute]n.\n\n=== \
CARACTER\[CapitalIAcute]STICAS ===\n- Detecci\[OAcute]n autom\[AAcute]tica \
multiplataforma (macOS/Windows/Unix)\n- B\[UAcute]squeda inteligente de \
pdflatex en ubicaciones est\[AAcute]ndar y PATH del sistema\n- Apertura autom\
\[AAcute]tica del PDF generado en el visor apropiado\n- Manejo robusto de \
errores con mensajes informativos\n- B\[UAcute]squeda flexible de editores \
(case-insensitive, coincidencia parcial)\n- Compatible con las principales \
distribuciones LaTeX (MacTeX, MiKTeX, TeXLive)\n\n=== EJEMPLO DE USO ===\n\
ShowAvailableEditors[]  (* Ver editores disponibles *) \n\
CompiladorTex[\"documento.tex\", \"PreferredEditor\" -> \"TeXstudio\"]\n\
RefreshEditors[]  (* Si instalas un nuevo editor *)", "Documentation" -> None,
     "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "VilTeX`SistemaCompilador"|>, False]]], "Output",
 CellChangeTimes->{3.9665230054127207`*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"01a9ebdf-4b6d-49d9-a90e-0e7fb8d892f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DetectLaTeXEditorsPattern", "Section",
 CellChangeTimes->{{3.966445811580113*^9, 3.96644581472791*^9}, {
   3.966447729452599*^9, 3.966447743404414*^9}, 
   3.96644783374667*^9},ExpressionUUID->"921fe881-7359-4444-92e7-\
3d64ef95dd56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DetectLaTeXEditorsPattern"}]], "Input",
 CellChangeTimes->{{3.966447835450575*^9, 3.966447836178265*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"83dc3943-62dd-4fe6-9bd4-8f00667c4b26"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DetectLaTeXEditorsPattern[] detecta \
autom\[AAcute]ticamente los editores LaTeX instalados en el sistema. Busca \
editores como TeXShop, TeXstudio, TeXmaker, Texifier, LaTeXiT, TeXworks y \
Visual Studio Code en las ubicaciones est\[AAcute]ndar seg\[UAcute]n el \
sistema operativo (macOS, Windows, Unix). Actualiza la variable global \
$LaTeXEditors con los editores encontrados. Retorna True si encuentra al \
menos un editor, False en caso contrario. Tarda un poco en el proceso de \
dectacci\[OAcute]n.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DetectLaTeXEditorsPattern", "[", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"detectedEditors", ",", "searchPatterns", ",", 
                    "allApps"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"detectedEditors", "=", 
                    RowBox[{"Association", "[", "]"}]}], ";", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"$OperatingSystem", ",", "\"MacOSX\"", ",", 
                    RowBox[{
                    RowBox[{"allApps", "=", 
                    RowBox[{"FileNames", "[", 
                    
                    RowBox[{"\"*.app\"", ",", "\"/Applications\"", ",", 
                    "\[Infinity]"}], "]"}]}], ";", 
                    RowBox[{"searchPatterns", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{
                    RowBox[{"\"TeXShop\"", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"texshop\"", ",", "\"tex/texshop\""}], "}"}]}], 
                    ",", 
                    RowBox[{"\"TeXstudio\"", "\[Rule]", 
                    RowBox[{"{", "\"texstudio\"", "}"}]}], ",", 
                    RowBox[{"\"TeXmaker\"", "\[Rule]", 
                    RowBox[{"{", "\"texmaker\"", "}"}]}], ",", 
                    RowBox[{"\"Texifier\"", "\[Rule]", 
                    RowBox[{"{", "\"texifier\"", "}"}]}], ",", 
                    RowBox[{"\"LaTeXiT\"", "\[Rule]", 
                    RowBox[{"{", "\"latexit\"", "}"}]}], ",", 
                    RowBox[{"\"TeXworks\"", "\[Rule]", 
                    RowBox[{"{", "\"texworks\"", "}"}]}], ",", 
                    RowBox[{"\"Visual Studio Code\"", "\[Rule]", 
                    RowBox[{"{", "\"visual studio code\"", "}"}]}]}], "]"}]}],
                     ";", 
                    RowBox[{"KeyValueMap", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"editorName", ",", "patterns"}], "}"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "foundApp", "}"}], ",", 
                    RowBox[{
                    RowBox[{"foundApp", "=", 
                    RowBox[{"SelectFirst", "[", 
                    RowBox[{"allApps", ",", 
                    RowBox[{"Function", "[", 
                    RowBox[{"app", ",", 
                    RowBox[{"AnyTrue", "[", 
                    RowBox[{"patterns", ",", 
                    RowBox[{"Function", "[", 
                    RowBox[{"pattern", ",", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToLowerCase", "[", "app", "]"}], ",", 
                    RowBox[{"ToLowerCase", "[", "pattern", "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"foundApp", "=!=", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], ",", 
                    RowBox[{"AssociateTo", "[", 
                    RowBox[{"detectedEditors", ",", 
                    RowBox[{"editorName", "\[Rule]", "foundApp"}]}], "]"}]}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", "searchPatterns"}], 
                    "]"}]}], ",", "\"Windows\"", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "editorPaths", "}"}], ",", 
                    RowBox[{
                    RowBox[{"editorPaths", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{
                    RowBox[{"\"TeXstudio\"", "\[Rule]", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"C:\\\\Program Files\\\\texstudio\\\\texstudio.exe\"", 
                    ",", "\"C:\\\\Program Files \
(x86)\\\\texstudio\\\\texstudio.exe\""}], "}"}]}], ",", 
                    RowBox[{"\"TeXmaker\"", "\[Rule]", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"C:\\\\Program Files\\\\Texmaker\\\\texmaker.exe\"", 
                    ",", "\"C:\\\\Program Files \
(x86)\\\\Texmaker\\\\texmaker.exe\"", ",", 
                    "\"C:\\\\Program Files\\\\texmaker\\\\texmaker.exe\""}], 
                    "}"}]}], ",", 
                    RowBox[{"\"TeXworks\"", "\[Rule]", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"C:\\\\Program \
Files\\\\MiKTeX\\\\miktex\\\\bin\\\\x64\\\\texworks.exe\"", ",", 
                    "\"C:\\\\Program \
Files\\\\MiKTeX\\\\miktex\\\\bin\\\\texworks.exe\"", ",", 
                    "\"C:\\\\Program Files (x86)\\\\MiKTeX\\\\miktex\\\\bin\\\
\\texworks.exe\"", ",", 
                    "\"C:\\\\Program Files\\\\MiKTeX \
2.9\\\\miktex\\\\bin\\\\x64\\\\texworks.exe\"", ",", 
                    "\"C:\\\\Program Files\\\\MiKTeX \
2.9\\\\miktex\\\\bin\\\\texworks.exe\"", ",", 
                    "\"C:\\\\Program Files (x86)\\\\MiKTeX \
2.9\\\\miktex\\\\bin\\\\x64\\\\texworks.exe\"", ",", 
                    "\"C:\\\\Program Files (x86)\\\\MiKTeX \
2.9\\\\miktex\\\\bin\\\\texworks.exe\"", ",", 
                    "\"C:\\\\MiKTeX\\\\miktex\\\\bin\\\\x64\\\\texworks.exe\"\
", ",", "\"C:\\\\MiKTeX\\\\miktex\\\\bin\\\\texworks.exe\"", ",", 
                    "\"C:\\\\texlive\\\\2024\\\\bin\\\\win32\\\\texworks.exe\"\
", ",", "\"C:\\\\texlive\\\\2025\\\\bin\\\\win32\\\\texworks.exe\"", ",", 
                    "\"C:\\\\texlive\\\\2024\\\\bin\\\\windows\\\\texworks.\
exe\"", ",", "\"C:\\\\texlive\\\\2025\\\\bin\\\\windows\\\\texworks.exe\"", 
                    ",", 
                    RowBox[{
                    "\"C:\\\\Users\\\\\"", "<>", "$UserName", "<>", 
                    "\"\\\\AppData\\\\Local\\\\Programs\\\\MiKTeX\\\\miktex\\\
\\bin\\\\x64\\\\texworks.exe\""}], ",", 
                    
                    RowBox[{"\"C:\\\\Users\\\\\"", "<>", "$UserName", "<>", 
                    "\"\\\\AppData\\\\Local\\\\Programs\\\\MiKTeX\\\\miktex\\\
\\bin\\\\texworks.exe\""}], ",", 
                    
                    RowBox[{"\"C:\\\\Users\\\\\"", "<>", "$UserName", "<>", 
                    "\"\\\\AppData\\\\Roaming\\\\MiKTeX\\\\miktex\\\\bin\\\\\
x64\\\\texworks.exe\""}], ",", 
                    
                    RowBox[{"\"C:\\\\Users\\\\\"", "<>", "$UserName", "<>", 
                    "\"\\\\AppData\\\\Roaming\\\\MiKTeX\\\\miktex\\\\bin\\\\\
texworks.exe\""}], ",", 
                    RowBox[{
                    "\"C:\\\\Users\\\\\"", "<>", "$UserName", "<>", 
                    "\"\\\\AppData\\\\Local\\\\MiKTeX\\\\miktex\\\\bin\\\\x64\
\\\\texworks.exe\""}], ",", 
                    RowBox[{
                    "\"C:\\\\Users\\\\\"", "<>", "$UserName", "<>", 
                    "\"\\\\AppData\\\\Local\\\\MiKTeX\\\\miktex\\\\bin\\\\\
texworks.exe\""}]}], "}"}]}]}], "]"}]}], ";", 
                    RowBox[{"KeyValueMap", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"editor", ",", "paths"}], "}"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "foundPath", "}"}], ",", 
                    RowBox[{
                    RowBox[{"foundPath", "=", 
                    RowBox[{"SelectFirst", "[", 
                    RowBox[{"paths", ",", "FileExistsQ", ",", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"foundPath", "=!=", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], ",", 
                    RowBox[{"AssociateTo", "[", 
                    RowBox[{"detectedEditors", ",", 
                    RowBox[{"editor", "\[Rule]", "foundPath"}]}], "]"}]}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", "editorPaths"}], 
                    "]"}]}]}], "]"}], ",", "\"Unix\"", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "editorPaths", "}"}], ",", 
                    RowBox[{
                    RowBox[{"editorPaths", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{
                    RowBox[{"\"TeXstudio\"", "\[Rule]", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"/usr/bin/texstudio\"", ",", 
                    "\"/usr/local/bin/texstudio\""}], "}"}]}], ",", 
                    RowBox[{"\"TeXmaker\"", "\[Rule]", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"/usr/bin/texmaker\"", ",", 
                    "\"/usr/local/bin/texmaker\""}], "}"}]}]}], "]"}]}], ";", 
                    
                    RowBox[{"KeyValueMap", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"editor", ",", "paths"}], "}"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "foundPath", "}"}], ",", 
                    RowBox[{
                    RowBox[{"foundPath", "=", 
                    RowBox[{"SelectFirst", "[", 
                    RowBox[{"paths", ",", "FileExistsQ", ",", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"foundPath", "=!=", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], ",", 
                    RowBox[{"AssociateTo", "[", 
                    RowBox[{"detectedEditors", ",", 
                    RowBox[{"editor", "\[Rule]", "foundPath"}]}], "]"}]}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", "editorPaths"}], 
                    "]"}]}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"$LaTeXEditors", "=", "detectedEditors"}], ";", 
                    RowBox[{
                    RowBox[{"Length", "[", "detectedEditors", "]"}], ">", 
                    "0"}]}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], \
"\<\"Global`DetectLaTeXEditorsPattern\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DetectLaTeXEditorsPattern[] detecta \
autom\[AAcute]ticamente los editores LaTeX instalados en el sistema. Busca \
editores como TeXShop, TeXstudio, TeXmaker, Texifier, LaTeXiT, TeXworks y \
Visual Studio Code en las ubicaciones est\[AAcute]ndar seg\[UAcute]n el \
sistema operativo (macOS, Windows, Unix). Actualiza la variable global \
$LaTeXEditors con los editores encontrados. Retorna True si encuentra al \
menos un editor, False en caso contrario. Tarda un poco en el proceso de \
dectacci\[OAcute]n.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DetectLaTeXEditorsPattern[] detecta autom\[AAcute]ticamente los editores \
LaTeX instalados en el sistema. Busca editores como TeXShop, TeXstudio, \
TeXmaker, Texifier, LaTeXiT, TeXworks y Visual Studio Code en las ubicaciones \
est\[AAcute]ndar seg\[UAcute]n el sistema operativo (macOS, Windows, Unix). \
Actualiza la variable global $LaTeXEditors con los editores encontrados. \
Retorna True si encuentra al menos un editor, False en caso contrario. Tarda \
un poco en el proceso de dectacci\[OAcute]n.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, $CellContext`DetectLaTeXEditorsPattern, \
{$CellContext`DetectLaTeXEditorsPattern[] :> 
       Module[{$CellContext`detectedEditors, $CellContext`searchPatterns, \
$CellContext`allApps}, $CellContext`detectedEditors = <||>; 
         Switch[$OperatingSystem, 
           "MacOSX", $CellContext`allApps = 
            FileNames[
             "*.app", "/Applications", 
              Infinity]; $CellContext`searchPatterns = <|
             "TeXShop" -> {"texshop", "tex/texshop"}, 
              "TeXstudio" -> {"texstudio"}, "TeXmaker" -> {"texmaker"}, 
              "Texifier" -> {"texifier"}, "LaTeXiT" -> {"latexit"}, 
              "TeXworks" -> {"texworks"}, 
              "Visual Studio Code" -> {"visual studio code"}|>; KeyValueMap[
             Function[{$CellContext`editorName, $CellContext`patterns}, 
              
              Module[{$CellContext`foundApp}, $CellContext`foundApp = 
                SelectFirst[$CellContext`allApps, 
                  Function[$CellContext`app, 
                   AnyTrue[$CellContext`patterns, 
                    Function[$CellContext`pattern, 
                    StringContainsQ[
                    ToLowerCase[$CellContext`app], 
                    ToLowerCase[$CellContext`pattern]]]]], 
                  Missing["NotFound"]]; 
               If[$CellContext`foundApp =!= Missing["NotFound"], 
                 
                 AssociateTo[$CellContext`detectedEditors, \
$CellContext`editorName -> $CellContext`foundApp]]]], \
$CellContext`searchPatterns], "Windows", 
           
           Module[{$CellContext`editorPaths}, $CellContext`editorPaths = <|
              "TeXstudio" -> {
                "C:\\Program Files\\texstudio\\texstudio.exe", 
                 "C:\\Program Files (x86)\\texstudio\\texstudio.exe"}, 
               "TeXmaker" -> {
                "C:\\Program Files\\Texmaker\\texmaker.exe", 
                 "C:\\Program Files (x86)\\Texmaker\\texmaker.exe", 
                 "C:\\Program Files\\texmaker\\texmaker.exe"}, 
               "TeXworks" -> {
                "C:\\Program Files\\MiKTeX\\miktex\\bin\\x64\\texworks.exe", 
                 "C:\\Program Files\\MiKTeX\\miktex\\bin\\texworks.exe", 
                 "C:\\Program Files (x86)\\MiKTeX\\miktex\\bin\\texworks.exe",
                  "C:\\Program Files\\MiKTeX \
2.9\\miktex\\bin\\x64\\texworks.exe", 
                 "C:\\Program Files\\MiKTeX 2.9\\miktex\\bin\\texworks.exe", 
                 "C:\\Program Files (x86)\\MiKTeX \
2.9\\miktex\\bin\\x64\\texworks.exe", 
                 "C:\\Program Files (x86)\\MiKTeX \
2.9\\miktex\\bin\\texworks.exe", "C:\\MiKTeX\\miktex\\bin\\x64\\texworks.exe",
                  "C:\\MiKTeX\\miktex\\bin\\texworks.exe", 
                 "C:\\texlive\\2024\\bin\\win32\\texworks.exe", 
                 "C:\\texlive\\2025\\bin\\win32\\texworks.exe", 
                 "C:\\texlive\\2024\\bin\\windows\\texworks.exe", 
                 "C:\\texlive\\2025\\bin\\windows\\texworks.exe", 
                 "C:\\Users\\" <> $UserName <> 
                 "\\AppData\\Local\\Programs\\MiKTeX\\miktex\\bin\\x64\\\
texworks.exe", "C:\\Users\\" <> $UserName <> 
                 "\\AppData\\Local\\Programs\\MiKTeX\\miktex\\bin\\texworks.\
exe", "C:\\Users\\" <> $UserName <> 
                 "\\AppData\\Roaming\\MiKTeX\\miktex\\bin\\x64\\texworks.exe",
                  "C:\\Users\\" <> $UserName <> 
                 "\\AppData\\Roaming\\MiKTeX\\miktex\\bin\\texworks.exe", 
                 "C:\\Users\\" <> $UserName <> 
                 "\\AppData\\Local\\MiKTeX\\miktex\\bin\\x64\\texworks.exe", 
                 "C:\\Users\\" <> $UserName <> 
                 "\\AppData\\Local\\MiKTeX\\miktex\\bin\\texworks.exe"}|>; 
            KeyValueMap[
              Function[{$CellContext`editor, $CellContext`paths}, 
               
               Module[{$CellContext`foundPath}, $CellContext`foundPath = 
                 SelectFirst[$CellContext`paths, FileExistsQ, 
                   Missing["NotFound"]]; 
                If[$CellContext`foundPath =!= Missing["NotFound"], 
                  
                  AssociateTo[$CellContext`detectedEditors, \
$CellContext`editor -> $CellContext`foundPath]]]], $CellContext`editorPaths]],
            "Unix", 
           
           Module[{$CellContext`editorPaths}, $CellContext`editorPaths = <|
              "TeXstudio" -> {
                "/usr/bin/texstudio", "/usr/local/bin/texstudio"}, 
               "TeXmaker" -> {
                "/usr/bin/texmaker", "/usr/local/bin/texmaker"}|>; KeyValueMap[
              Function[{$CellContext`editor, $CellContext`paths}, 
               
               Module[{$CellContext`foundPath}, $CellContext`foundPath = 
                 SelectFirst[$CellContext`paths, FileExistsQ, 
                   Missing["NotFound"]]; 
                If[$CellContext`foundPath =!= Missing["NotFound"], 
                  
                  AssociateTo[$CellContext`detectedEditors, \
$CellContext`editor -> $CellContext`foundPath]]]], \
$CellContext`editorPaths]]]; $CellContext`$LaTeXEditors = \
$CellContext`detectedEditors; Length[$CellContext`detectedEditors] > 0]}], 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "Global`DetectLaTeXEditorsPattern"|>, False]]], "Output",
 CellChangeTimes->{3.966447837167781*^9, 3.966447965040164*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"9ce6c6a7-4546-4701-aa79-c192111a40fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DetectLaTeXEditorsPattern", "[", "]"}]], "Input",
 CellChangeTimes->{3.966447872650425*^9},
 CellLabel->"In[25]:=",ExpressionUUID->"8dde7510-d0c6-4341-b70a-c9a17cbc10fc"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.96644789916367*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"5847b952-c481-4036-9d3c-b52a1d29d520"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ShowAvaibleEditors", "Section",
 CellChangeTimes->{{3.966445811580113*^9, 3.96644581472791*^9}, {
  3.966447729452599*^9, 
  3.966447743404414*^9}},ExpressionUUID->"5df9630f-bf40-470f-b7fb-\
f430b0553949"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ShowAvailableEditors"}]], "Input",
 CellChangeTimes->{{3.966447772492474*^9, 3.966447776350339*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"fea48c15-0d67-4f84-93eb-f6a797f5b73e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ShowAvailableEditors[] muestra en pantalla todos \
los editores LaTeX detectados en el sistema. Si no hay editores detectados \
previamente, ejecuta autom\[AAcute]ticamente DetectLaTeXEditorsPattern[]. \
Imprime una lista con checkmarks mostrando el nombre del editor y su ubicaci\
\[OAcute]n. Si no encuentra editores, muestra sugerencias de instalaci\
\[OAcute]n. No tiene par\[AAcute]metros ni opciones.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ShowAvailableEditors", "[", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "$LaTeXEditors", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", "\"Detectando editores LaTeX...\"", 
                    "]"}], ";", 
                    RowBox[{"DetectLaTeXEditorsPattern", "[", "]"}], ";"}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Mostrando editores ya detectados...\"", "]"}], ";"}]}],
                     "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "$LaTeXEditors", "]"}], ">", "0"}],
                     ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"=== EDITORES LaTeX DETECTADOS ===\"", "]"}], ";", 
                    RowBox[{"KeyValueMap", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"editor", ",", "path"}], "}"}], ",", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"\[Checkmark] \"", ",", "editor", ",", 
                    "\" \[RightArrow] \"", ",", 
                    RowBox[{"FileBaseName", "[", "path", "]"}]}], "]"}]}], 
                    "]"}], ",", "$LaTeXEditors"}], "]"}], ";"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"No se encontraron editores LaTeX instalados.\"", "]"}],
                     ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"Sugerencia: Instala TeXstudio, TeXmaker, o MacTeX.\"", 
                    "]"}]}]}], "]"}], ";"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`ShowAvailableEditors\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ShowAvailableEditors[] muestra en pantalla todos \
los editores LaTeX detectados en el sistema. Si no hay editores detectados \
previamente, ejecuta autom\[AAcute]ticamente DetectLaTeXEditorsPattern[]. \
Imprime una lista con checkmarks mostrando el nombre del editor y su ubicaci\
\[OAcute]n. Si no encuentra editores, muestra sugerencias de instalaci\
\[OAcute]n. No tiene par\[AAcute]metros ni opciones.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ShowAvailableEditors[] muestra en pantalla todos los editores LaTeX \
detectados en el sistema. Si no hay editores detectados previamente, ejecuta \
autom\[AAcute]ticamente DetectLaTeXEditorsPattern[]. Imprime una lista con \
checkmarks mostrando el nombre del editor y su ubicaci\[OAcute]n. Si no \
encuentra editores, muestra sugerencias de instalaci\[OAcute]n. No tiene par\
\[AAcute]metros ni opciones.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, $CellContext`ShowAvailableEditors, \
{$CellContext`ShowAvailableEditors[] :> 
       Module[{}, 
         If[Length[$CellContext`$LaTeXEditors] == 0, 
           Print["Detectando editores LaTeX..."]; \
$CellContext`DetectLaTeXEditorsPattern[]; Null, 
           Print["Mostrando editores ya detectados..."]; Null]; 
         If[Length[$CellContext`$LaTeXEditors] > 0, 
           Print["=== EDITORES LaTeX DETECTADOS ==="]; KeyValueMap[
             Function[{$CellContext`editor, $CellContext`path}, 
              Print["\[Checkmark] ", $CellContext`editor, " \[RightArrow] ", 
               FileBaseName[$CellContext`path]]], $CellContext`$LaTeXEditors]; 
           Null, Print["No se encontraron editores LaTeX instalados."]; 
           Print["Sugerencia: Instala TeXstudio, TeXmaker, o MacTeX."]]; 
         Null]}], "SubValues" -> None, "DefaultValues" -> None, "NValues" -> 
    None, "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, 
    "FullName" -> "Global`ShowAvailableEditors"|>, False]]], "Output",
 CellChangeTimes->{3.9664477775681477`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"7274a262-bdf0-4a6c-a635-4d6c3d3a9fde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowAvailableEditors", "[", "]"}]], "Input",
 CellChangeTimes->{{3.966447752908292*^9, 3.966447768081812*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"42bfb7e8-eaf0-4a0c-bca4-e1d7bfd52300"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.966447797853054*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[23]:=",ExpressionUUID->"bd5f9d5d-079c-4e5a-ac5f-6ef50c88a183"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.9664477978547792`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[23]:=",ExpressionUUID->"f00d2e37-a805-4932-80e0-83128e57be6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966447797856277*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[23]:=",ExpressionUUID->"c6bf8c78-918b-4b90-b079-3aaf8c637bc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966447797857244*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[23]:=",ExpressionUUID->"f68fa79f-60b9-48ba-ac48-6bb8a9223a40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9664477978581057`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[23]:=",ExpressionUUID->"6ff4557c-250a-448b-a499-e640ae4463cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9664477978588877`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[23]:=",ExpressionUUID->"93d01d61-2672-4acf-9b92-9f743cb26f4c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RefreshEditors", "Section",
 CellChangeTimes->{{3.966445811580113*^9, 3.96644581472791*^9}, {
   3.966447729452599*^9, 3.966447743404414*^9}, 3.96644783374667*^9, 
   3.966448016948551*^9},ExpressionUUID->"ed3493a0-5e21-44f6-8b88-\
1305050d215e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "RefreshEditors"}]], "Input",
 CellChangeTimes->{{3.966448019645451*^9, 3.966448022745593*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"eda81689-7d22-4990-b5d5-8565c61a0726"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"RefreshEditors[] fuerza una nueva detecci\[OAcute]n \
de editores LaTeX limpiando la cache anterior. Reinicia la variable \
$LaTeXEditors y ejecuta una nueva b\[UAcute]squeda de editores instalados. \
\[CapitalUAcute]til cuando se instala un nuevo editor despu\[EAcute]s de \
haber ejecutado la detecci\[OAcute]n inicial. Muestra el n\[UAcute]mero de \
editores detectados y llama a ShowAvailableEditors[] autom\[AAcute]ticamente. \
No tiene par\[AAcute]metros ni opciones.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"RefreshEditors", "[", "]"}], ":=", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{
                    "Print", "[", 
                    "\"Refrescando detecci\[OAcute]n de editores...\"", "]"}],
                     ";", 
                    RowBox[{"$LaTeXEditors", "=", 
                    RowBox[{"Association", "[", "]"}]}], ";", 
                    RowBox[{"DetectLaTeXEditorsPattern", "[", "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Editores detectados: \"", ",", 
                    RowBox[{"Length", "[", "$LaTeXEditors", "]"}]}], "]"}], 
                    ";", 
                    RowBox[{"ShowAvailableEditors", "[", "]"}], ";"}], 
                    ")"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`RefreshEditors\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"RefreshEditors[] fuerza una nueva detecci\[OAcute]n \
de editores LaTeX limpiando la cache anterior. Reinicia la variable \
$LaTeXEditors y ejecuta una nueva b\[UAcute]squeda de editores instalados. \
\[CapitalUAcute]til cuando se instala un nuevo editor despu\[EAcute]s de \
haber ejecutado la detecci\[OAcute]n inicial. Muestra el n\[UAcute]mero de \
editores detectados y llama a ShowAvailableEditors[] autom\[AAcute]ticamente. \
No tiene par\[AAcute]metros ni opciones.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "RefreshEditors[] fuerza una nueva detecci\[OAcute]n de editores LaTeX \
limpiando la cache anterior. Reinicia la variable $LaTeXEditors y ejecuta una \
nueva b\[UAcute]squeda de editores instalados. \[CapitalUAcute]til cuando se \
instala un nuevo editor despu\[EAcute]s de haber ejecutado la \
detecci\[OAcute]n inicial. Muestra el n\[UAcute]mero de editores detectados y \
llama a ShowAvailableEditors[] autom\[AAcute]ticamente. No tiene \
par\[AAcute]metros ni opciones.", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, $CellContext`RefreshEditors, {$CellContext`RefreshEditors[] :> \
(Print["Refrescando detecci\[OAcute]n de editores..."]; \
$CellContext`$LaTeXEditors = <||>; $CellContext`DetectLaTeXEditorsPattern[]; 
        Print["Editores detectados: ", 
          
          Length[$CellContext`$LaTeXEditors]]; \
$CellContext`ShowAvailableEditors[]; Null)}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "Global`RefreshEditors"|>, False]]], "Output",
 CellChangeTimes->{3.966448023589905*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"44f2858d-abb4-4b90-b0a5-4cc2e640af08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RefreshEditors", "[", "]"}]], "Input",
 CellChangeTimes->{3.966448048093824*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"04658ea3-b44d-4622-9e70-887920f48fd6"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Refrescando detecci\[OAcute]n de editores...\"\>"], "Print",
 CellChangeTimes->{3.9664480488579493`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"1f07936e-3b4b-4eac-8e7b-a7e7b41a2e39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editores detectados: \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["Editores detectados: ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448074548154*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"7043bbd8-6c70-4664-bb50-261f191a68c0"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.966448074549098*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"cc96bb9c-49c1-4c1d-be41-d8758e56992f"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.966448074549608*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"03c638af-3647-4eb9-9995-5231ce5dad2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448074550074*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"3be2c79f-704a-471e-8b54-af59fda4bdd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448074550583*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"ef354e1b-81cf-444b-892d-f47e85eda815"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9664480745510902`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"e0c04728-4f1f-48a2-b816-d2d6674fb0c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448074551559*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"7c5c967d-6105-4fde-beb2-0d76266aca91"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiladorTex", "Section",
 CellChangeTimes->{{3.966445811580113*^9, 3.96644581472791*^9}, {
   3.966447729452599*^9, 3.966447743404414*^9}, 3.96644783374667*^9, 
   3.966448016948551*^9, 
   3.966448102508333*^9},ExpressionUUID->"79f05bba-7ba8-4e77-8ee7-\
aff11e6e165b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "CompiladorTex"}]], "Input",
 CellChangeTimes->{{3.966448104123855*^9, 3.966448104857993*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"6eaa5950-2b34-4a65-8848-d72de1e2bd21"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"CompiladorTex[filePath, opts] abre un archivo LaTeX \
en un editor y lo compila a PDF. filePath: ruta al archivo .tex (String). Si \
no tiene extensi\[OAcute]n .tex, se a\[NTilde]ade autom\[AAcute]ticamente. \
\\n\\nOpciones disponibles:\\n- \\\"PreferredEditor\\\" -> Automatic (por \
defecto): usa el primer editor detectado\\n- \\\"PreferredEditor\\\" -> \
\\\"NombreEditor\\\": especifica un editor particular\\n  Editores \
soportados: \\\"TeXShop\\\", \\\"TeXstudio\\\", \\\"TeXmaker\\\", \
\\\"Texifier\\\", \\\"LaTeXiT\\\", \\\"TeXworks\\\", \\\"Visual Studio Code\\\
\"\\n  La b\[UAcute]squeda es flexible (case-insensitive y coincidencia \
parcial)\\n\\nEjemplos:\\nCompiladorTex[\\\"documento.tex\\\"]\\\
nCompiladorTex[\\\"mi_archivo\\\", \\\"PreferredEditor\\\" -> \\\"TeXstudio\\\
\"]\\nCompiladorTex[\\\"~/Desktop/paper.tex\\\", \\\"PreferredEditor\\\" -> \
\\\"texmaker\\\"]\\n\\nRetorna la ruta del PDF generado si la compilaci\
\[OAcute]n es exitosa, o la ruta del archivo .tex si hay errores de compilaci\
\[OAcute]n.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"CompiladorTex", "[", 
                    RowBox[{"filePath_String", ",", "opts___Rule"}], "]"}], 
                    ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"validatedPath", ",", "preferredEditor", ",", 
                    "editorToUse", ",", "editorPath", ",", "result", ",", 
                    "compileResult", ",", "pdfPath", ",", "latexCommand", ",",
                     "workingDir"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "$LaTeXEditors", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Detectando editores LaTeX (primera vez)...\"", "]"}], 
                    ";", 
                    RowBox[{"DetectLaTeXEditorsPattern", "[", "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Editores detectados: \"", ",", 
                    RowBox[{"Length", "[", "$LaTeXEditors", "]"}]}], "]"}], 
                    ";"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Usando editores ya detectados: \"", ",", 
                    RowBox[{"Length", "[", "$LaTeXEditors", "]"}], ",", 
                    "\" disponibles\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"preferredEditor", "=", 
                    RowBox[{
                    RowBox[{"\"PreferredEditor\"", "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", "opts", "}"}]}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"\"PreferredEditor\"", "\[Rule]", 
                    "Automatic"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "preferredEditor", "]"}], ",", 
                    RowBox[{
                    RowBox[{"preferredEditor", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"preferredEditor", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\[InvisibleSpace]\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"\[VeryThinSpace]\"", "\[Rule]", "\"\""}], ",", 
                    
                    RowBox[{"\"\[ThinSpace]\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"\[MediumSpace]\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"\[ThickSpace]\"", "\[Rule]", "\"\""}]}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"validatedPath", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"filePath", ",", "\".tex\""}], "]"}], ",", 
                    "filePath", ",", 
                    RowBox[{"filePath", "<>", "\".tex\""}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"FileExistsQ", "[", "validatedPath", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Error: El archivo \"", ",", "validatedPath", 
                    ",", "\" no existe.\""}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"validatedPath", "=", 
                    RowBox[{"ExpandFileName", "[", "validatedPath", "]"}]}], 
                    ";", 
                    RowBox[{"workingDir", "=", 
                    RowBox[{"DirectoryName", "[", "validatedPath", "]"}]}], 
                    ";", 
                    RowBox[{"Print", "[", "\"Buscando pdflatex...\"", "]"}], 
                    ";", 
                    RowBox[{"latexCommand", "=", 
                    RowBox[{"FindPdfLaTeX", "[", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"latexCommand", "===", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"ERROR: No se encontr\[OAcute] pdflatex instalado.\"", 
                    "]"}], ";", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"$OperatingSystem", ",", "\"MacOSX\"", ",", 
                    
                    RowBox[{"Print", "[", 
                    "\"Soluci\[OAcute]n: Instala MacTeX desde \
https://www.tug.org/mactex/\"", "]"}], ",", "\"Windows\"", ",", 
                    
                    RowBox[{"Print", "[", 
                    "\"Soluci\[OAcute]n: Instala MiKTeX desde \
https://miktex.org/\"", "]"}], ",", "\"Unix\"", ",", 
                    
                    RowBox[{"Print", "[", 
                    "\"Soluci\[OAcute]n: Instala texlive usando tu gestor de \
paquetes\"", "]"}]}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"pdflatex encontrado: \"", ",", 
                    "latexCommand"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "$LaTeXEditors", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: No se encontraron editores LaTeX instalados.\"",
                     "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"Instala TeXstudio, TeXmaker, o MacTeX.\"", "]"}], ";", 
                    
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"editorToUse", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"preferredEditor", "===", "Automatic"}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"Keys", "[", "$LaTeXEditors", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "preferredEditor", "]"}], "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    RowBox[{"$LaTeXEditors", ",", "preferredEditor"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Editor '\"", ",", "preferredEditor", ",", 
                    "\"' encontrado (match exacto)\""}], "]"}], ";", 
                    "preferredEditor"}], ",", 
                    RowBox[{"StringQ", "[", "preferredEditor", "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "flexibleMatch", "}"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Buscando editor '\"", ",", "preferredEditor", 
                    ",", "\"' de forma flexible...\""}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Editores disponibles: \"", ",", 
                    RowBox[{"Keys", "[", "$LaTeXEditors", "]"}]}], "]"}], ";", 
                    RowBox[{"flexibleMatch", "=", 
                    RowBox[{"SelectFirst", "[", 
                    RowBox[{
                    RowBox[{"Keys", "[", "$LaTeXEditors", "]"}], ",", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToLowerCase", "[", "#1", "]"}], ",", 
                    RowBox[{"ToLowerCase", "[", "preferredEditor", "]"}]}], 
                    "]"}], "&"}], ",", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"flexibleMatch", "=!=", 
                    RowBox[{"Missing", "[", "\"NotFound\"", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Editor encontrado: '\"", ",", "flexibleMatch", 
                    ",", "\"' (match flexible)\""}], "]"}], ";", 
                    "flexibleMatch"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Editor '\"", ",", "preferredEditor", ",", 
                    "\"' no encontrado\""}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Usando editor por defecto: \"", ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"Keys", "[", "$LaTeXEditors", "]"}], "]"}]}], 
                    "]"}], ";", 
                    RowBox[{"First", "[", 
                    RowBox[{"Keys", "[", "$LaTeXEditors", "]"}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ",", "True", ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"Keys", "[", "$LaTeXEditors", "]"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"editorPath", "=", 
                    RowBox[{"$LaTeXEditors", "[", "editorToUse", "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Abriendo archivo en \"", ",", "editorToUse", 
                    ",", "\"...\""}], "]"}], ";", 
                    RowBox[{"result", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"$OperatingSystem", ",", "\"MacOSX\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"editorPath", ",", "\".app\""}], "]"}], ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"open\"", ",", "\"-a\"", ",", "editorPath", ",",
                     "validatedPath"}], "}"}], "]"}], ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    RowBox[{"editorPath", ",", "validatedPath"}], "}"}], 
                    "]"}]}], "]"}], ",", "\"Windows\"", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "processObj", "}"}], ",", 
                    RowBox[{
                    RowBox[{"processObj", "=", 
                    RowBox[{"StartProcess", "[", 
                    RowBox[{"{", 
                    RowBox[{"editorPath", ",", "validatedPath"}], "}"}], 
                    "]"}]}], ";", 
                    RowBox[{"Association", "[", 
                    RowBox[{"\"ExitCode\"", "\[Rule]", "0"}], "]"}]}]}], 
                    "]"}], ",", "\"Unix\"", ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    RowBox[{"editorPath", ",", "validatedPath"}], "}"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"result", "[", "\"ExitCode\"", "]"}], 
                    "\[NotEqual]", "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"El editor se abri\[OAcute] en segundo plano o no se \
pudo verificar su apertura.\"", "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"Continuando con la compilaci\[OAcute]n...\"", "]"}], 
                    ";"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", "\"Editor abierto correctamente\"", 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"Pause", "[", "1", "]"}], ";", 
                    
                    RowBox[{"Print", "[", "\"Compilando documento LaTeX...\"",
                     "]"}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Directorio de trabajo: \"", ",", 
                    "workingDir"}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Archivo: \"", ",", 
                    RowBox[{"FileBaseName", "[", "validatedPath", "]"}]}], 
                    "]"}], ";", 
                    RowBox[{"compileResult", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"$OperatingSystem", ",", "\"Windows\"", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"originalDir", ",", "fileName"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"originalDir", "=", 
                    RowBox[{"Directory", "[", "]"}]}], ";", 
                    RowBox[{"fileName", "=", 
                    RowBox[{
                    RowBox[{"FileBaseName", "[", "validatedPath", "]"}], "<>",
                     "\".tex\""}]}], ";", 
                    RowBox[{"SetDirectory", "[", "workingDir", "]"}], ";", 
                    RowBox[{"compileResult", "=", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"latexCommand", ",", 
                    "\"-interaction=nonstopmode\"", ",", "fileName"}], "}"}], 
                    "]"}]}], ";", 
                    RowBox[{"SetDirectory", "[", "originalDir", "]"}], ";", 
                    "compileResult"}]}], "]"}], ",", "_", ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    RowBox[{"latexCommand", ",", 
                    "\"-interaction=nonstopmode\"", ",", 
                    RowBox[{"\"-output-directory=\"", "<>", "workingDir"}], 
                    ",", "validatedPath"}], "}"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"pdfPath", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"validatedPath", ",", 
                    RowBox[{"\".tex\"", "\[Rule]", "\".pdf\""}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"compileResult", "[", "\"ExitCode\"", "]"}], 
                    "\[Equal]", "0"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FileExistsQ", "[", "pdfPath", "]"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", "\"Compilaci\[OAcute]n exitosa\"", 
                    "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"PDF generado: \"", ",", "pdfPath"}], "]"}], 
                    ";", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"$OperatingSystem", ",", "\"MacOSX\"", ",", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"editorToUse", ",", "\"TeXShop\"", ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"open\"", ",", "\"-a\"", ",", "\"TeXShop\"", 
                    ",", "pdfPath"}], "}"}], "]"}], ",", "\"TeXstudio\"", ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"open\"", ",", "\"-a\"", ",", 
                    RowBox[{"FileBaseName", "[", "editorPath", "]"}], ",", 
                    "pdfPath"}], "}"}], "]"}], ",", "\"TeXmaker\"", ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"open\"", ",", "\"-a\"", ",", "\"texmaker\"", 
                    ",", "pdfPath"}], "}"}], "]"}], ",", "\"Texifier\"", ",", 
                    
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"open\"", ",", "\"-a\"", ",", "\"Texifier\"", 
                    ",", "pdfPath"}], "}"}], "]"}], ",", "_", ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"open\"", ",", "pdfPath"}], "}"}], "]"}]}], 
                    "]"}], ",", "\"Windows\"", ",", 
                    RowBox[{"SystemOpen", "[", "pdfPath", "]"}], ",", "_", 
                    ",", 
                    RowBox[{"RunProcess", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"xdg-open\"", ",", "pdfPath"}], "}"}], "]"}]}], 
                    "]"}], ";", "pdfPath"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Compilaci\[OAcute]n realizada pero PDF no \
encontrado\"", "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"Revisa los errores en el editor LaTeX\"", "]"}], ";", 
                    "validatedPath"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Error en compilaci\[OAcute]n (Exit Code: \"", 
                    ",", 
                    RowBox[{"compileResult", "[", "\"ExitCode\"", "]"}], ",", 
                    "\")\""}], "]"}], ";", 
                    RowBox[{"Print", "[", "\"Detalles del error:\"", "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringLength", "[", 
                    RowBox[{"compileResult", "[", "\"StandardError\"", "]"}], 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: \"", ",", 
                    
                    RowBox[{"compileResult", "[", "\"StandardError\"", 
                    "]"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringLength", "[", 
                    RowBox[{"compileResult", "[", "\"StandardOutput\"", "]"}],
                     "]"}], ">", "0"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Output: \"", ",", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{
                    RowBox[{"compileResult", "[", "\"StandardOutput\"", "]"}],
                     ",", 
                    RowBox[{"UpTo", "[", "1000", "]"}]}], "]"}]}], "]"}]}], 
                    "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"Revisa el archivo LaTeX en el editor para corregir \
errores\"", "]"}], ";", "validatedPath"}]}], "]"}]}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`CompiladorTex\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"CompiladorTex[filePath, opts] abre un archivo LaTeX \
en un editor y lo compila a PDF. filePath: ruta al archivo .tex (String). Si \
no tiene extensi\[OAcute]n .tex, se a\[NTilde]ade autom\[AAcute]ticamente. \
\\n\\nOpciones disponibles:\\n- \\\"PreferredEditor\\\" -> Automatic (por \
defecto): usa el primer editor detectado\\n- \\\"PreferredEditor\\\" -> \
\\\"NombreEditor\\\": especifica un editor particular\\n  Editores \
soportados: \\\"TeXShop\\\", \\\"TeXstudio\\\", \\\"TeXmaker\\\", \
\\\"Texifier\\\", \\\"LaTeXiT\\\", \\\"TeXworks\\\", \\\"Visual Studio Code\\\
\"\\n  La b\[UAcute]squeda es flexible (case-insensitive y coincidencia \
parcial)\\n\\nEjemplos:\\nCompiladorTex[\\\"documento.tex\\\"]\\\
nCompiladorTex[\\\"mi_archivo\\\", \\\"PreferredEditor\\\" -> \\\"TeXstudio\\\
\"]\\nCompiladorTex[\\\"~/Desktop/paper.tex\\\", \\\"PreferredEditor\\\" -> \
\\\"texmaker\\\"]\\n\\nRetorna la ruta del PDF generado si la compilaci\
\[OAcute]n es exitosa, o la ruta del archivo .tex si hay errores de compilaci\
\[OAcute]n.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "CompiladorTex[filePath, opts] abre un archivo LaTeX en un editor y lo \
compila a PDF. filePath: ruta al archivo .tex (String). Si no tiene extensi\
\[OAcute]n .tex, se a\[NTilde]ade autom\[AAcute]ticamente. \n\nOpciones \
disponibles:\n- \"PreferredEditor\" -> Automatic (por defecto): usa el primer \
editor detectado\n- \"PreferredEditor\" -> \"NombreEditor\": especifica un \
editor particular\n  Editores soportados: \"TeXShop\", \"TeXstudio\", \
\"TeXmaker\", \"Texifier\", \"LaTeXiT\", \"TeXworks\", \"Visual Studio Code\"\
\n  La b\[UAcute]squeda es flexible (case-insensitive y coincidencia parcial)\
\n\nEjemplos:\nCompiladorTex[\"documento.tex\"]\n\
CompiladorTex[\"mi_archivo\", \"PreferredEditor\" -> \"TeXstudio\"]\n\
CompiladorTex[\"~/Desktop/paper.tex\", \"PreferredEditor\" -> \"texmaker\"]\n\
\nRetorna la ruta del PDF generado si la compilaci\[OAcute]n es exitosa, o la \
ruta del archivo .tex si hay errores de compilaci\[OAcute]n.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, $CellContext`CompiladorTex, {$CellContext`CompiladorTex[
         Pattern[$CellContext`filePath, 
          Blank[String]], 
         Pattern[$CellContext`opts, 
          BlankNullSequence[Rule]]] :> 
       Module[{$CellContext`validatedPath, $CellContext`preferredEditor, \
$CellContext`editorToUse, $CellContext`editorPath, $CellContext`result, \
$CellContext`compileResult, $CellContext`pdfPath, $CellContext`latexCommand, \
$CellContext`workingDir}, 
         If[Length[$CellContext`$LaTeXEditors] == 0, 
           Print["Detectando editores LaTeX (primera vez)..."]; \
$CellContext`DetectLaTeXEditorsPattern[]; Print["Editores detectados: ", 
             Length[$CellContext`$LaTeXEditors]]; Null, 
           Print["Usando editores ya detectados: ", 
             Length[$CellContext`$LaTeXEditors], " disponibles"]; 
           Null]; $CellContext`preferredEditor = ReplaceAll[
            ReplaceAll["PreferredEditor", {$CellContext`opts}], 
            "PreferredEditor" -> Automatic]; If[
           
           StringQ[$CellContext`preferredEditor], \
$CellContext`preferredEditor = 
            StringReplace[$CellContext`preferredEditor, {
              "\[InvisibleSpace]" -> "", "\[VeryThinSpace]" -> "", 
               "\[ThinSpace]" -> "", "\[MediumSpace]" -> "", "\[ThickSpace]" -> 
               ""}]; Null]; $CellContext`validatedPath = If[
            
            StringEndsQ[$CellContext`filePath, 
             ".tex"], $CellContext`filePath, $CellContext`filePath <> ".tex"]; 
         If[
           Not[
            FileExistsQ[$CellContext`validatedPath]], 
           Print["Error: El archivo ", $CellContext`validatedPath, 
             " no existe."]; Return[$Failed]]; $CellContext`validatedPath = 
          ExpandFileName[$CellContext`validatedPath]; $CellContext`workingDir = 
          DirectoryName[$CellContext`validatedPath]; 
         Print["Buscando pdflatex..."]; $CellContext`latexCommand = \
$CellContext`FindPdfLaTeX[]; 
         If[$CellContext`latexCommand === Missing["NotFound"], 
           Print["ERROR: No se encontr\[OAcute] pdflatex instalado."]; 
           Switch[$OperatingSystem, "MacOSX", 
             Print[
             "Soluci\[OAcute]n: Instala MacTeX desde \
https://www.tug.org/mactex/"], "Windows", 
             Print[
             "Soluci\[OAcute]n: Instala MiKTeX desde https://miktex.org/"], 
             "Unix", 
             Print[
             "Soluci\[OAcute]n: Instala texlive usando tu gestor de \
paquetes"]]; Return[$Failed]]; 
         Print["pdflatex encontrado: ", $CellContext`latexCommand]; 
         If[Length[$CellContext`$LaTeXEditors] == 0, 
           Print["Error: No se encontraron editores LaTeX instalados."]; 
           Print["Instala TeXstudio, TeXmaker, o MacTeX."]; 
           Return[$Failed]]; $CellContext`editorToUse = 
          Which[$CellContext`preferredEditor === Automatic, 
            First[
             Keys[$CellContext`$LaTeXEditors]], 
            And[
             StringQ[$CellContext`preferredEditor], 
             
             KeyExistsQ[$CellContext`$LaTeXEditors, \
$CellContext`preferredEditor]], 
            Print["Editor '", $CellContext`preferredEditor, 
              "' encontrado (match exacto)"]; $CellContext`preferredEditor, 
            StringQ[$CellContext`preferredEditor], 
            
            Module[{$CellContext`flexibleMatch}, 
             Print["Buscando editor '", $CellContext`preferredEditor, 
               "' de forma flexible..."]; Print["Editores disponibles: ", 
               Keys[$CellContext`$LaTeXEditors]]; $CellContext`flexibleMatch = 
              SelectFirst[
                Keys[$CellContext`$LaTeXEditors], StringContainsQ[
                 ToLowerCase[#], 
                 ToLowerCase[$CellContext`preferredEditor]]& , 
                Missing["NotFound"]]; 
             If[$CellContext`flexibleMatch =!= Missing["NotFound"], 
               Print["Editor encontrado: '", $CellContext`flexibleMatch, 
                 "' (match flexible)"]; $CellContext`flexibleMatch, 
               Print["Editor '", $CellContext`preferredEditor, 
                 "' no encontrado"]; Print["Usando editor por defecto: ", 
                 First[
                  Keys[$CellContext`$LaTeXEditors]]]; First[
                 Keys[$CellContext`$LaTeXEditors]]]], True, 
            First[
             
             Keys[$CellContext`$LaTeXEditors]]]; $CellContext`editorPath = \
$CellContext`$LaTeXEditors[$CellContext`editorToUse]; 
         Print["Abriendo archivo en ", $CellContext`editorToUse, 
           "..."]; $CellContext`result = Switch[$OperatingSystem, "MacOSX", 
            If[
             StringContainsQ[$CellContext`editorPath, ".app"], 
             
             RunProcess[{
              "open", "-a", $CellContext`editorPath, \
$CellContext`validatedPath}], 
             
             RunProcess[{$CellContext`editorPath, \
$CellContext`validatedPath}]], "Windows", 
            
            Module[{$CellContext`processObj}, $CellContext`processObj = 
              StartProcess[{$CellContext`editorPath, \
$CellContext`validatedPath}]; <|"ExitCode" -> 0|>], "Unix", 
            
            RunProcess[{$CellContext`editorPath, \
$CellContext`validatedPath}]]; 
         If[$CellContext`result["ExitCode"] != 0, 
           Print["El editor se abri\[OAcute] en segundo plano o no se pudo \
verificar su apertura."]; Print["Continuando con la compilaci\[OAcute]n..."]; 
           Null, Print["Editor abierto correctamente"]; Null]; Pause[1]; 
         Print["Compilando documento LaTeX..."]; 
         Print["Directorio de trabajo: ", $CellContext`workingDir]; 
         Print["Archivo: ", 
           
           FileBaseName[$CellContext`validatedPath]]; \
$CellContext`compileResult = Switch[$OperatingSystem, "Windows", 
            
            Module[{$CellContext`originalDir, $CellContext`fileName}, \
$CellContext`originalDir = Directory[]; $CellContext`fileName = 
              FileBaseName[$CellContext`validatedPath] <> ".tex"; 
             SetDirectory[$CellContext`workingDir]; \
$CellContext`compileResult = 
              RunProcess[{$CellContext`latexCommand, 
                 "-interaction=nonstopmode", $CellContext`fileName}]; 
             SetDirectory[$CellContext`originalDir]; \
$CellContext`compileResult], 
            Blank[], 
            
            RunProcess[{$CellContext`latexCommand, "-interaction=nonstopmode",
               "-output-directory=" <> $CellContext`workingDir, \
$CellContext`validatedPath}]]; $CellContext`pdfPath = 
          StringReplace[$CellContext`validatedPath, ".tex" -> ".pdf"]; 
         If[$CellContext`compileResult["ExitCode"] == 0, 
           If[
            FileExistsQ[$CellContext`pdfPath], 
            Print["Compilaci\[OAcute]n exitosa"]; 
            Print["PDF generado: ", $CellContext`pdfPath]; 
            Switch[$OperatingSystem, "MacOSX", 
              Switch[$CellContext`editorToUse, "TeXShop", 
               RunProcess[{"open", "-a", "TeXShop", $CellContext`pdfPath}], 
               "TeXstudio", 
               RunProcess[{"open", "-a", 
                 
                 FileBaseName[$CellContext`editorPath], \
$CellContext`pdfPath}], "TeXmaker", 
               RunProcess[{"open", "-a", "texmaker", $CellContext`pdfPath}], 
               "Texifier", 
               RunProcess[{"open", "-a", "Texifier", $CellContext`pdfPath}], 
               Blank[], 
               RunProcess[{"open", $CellContext`pdfPath}]], "Windows", 
              SystemOpen[$CellContext`pdfPath], 
              Blank[], 
              
              RunProcess[{
               "xdg-open", $CellContext`pdfPath}]]; $CellContext`pdfPath, 
            Print["Compilaci\[OAcute]n realizada pero PDF no encontrado"]; 
            Print["Revisa los errores en el editor LaTeX"]; \
$CellContext`validatedPath], 
           Print["Error en compilaci\[OAcute]n (Exit Code: ", 
             $CellContext`compileResult["ExitCode"], ")"]; 
           Print["Detalles del error:"]; If[StringLength[
               $CellContext`compileResult["StandardError"]] > 0, 
             Print["Error: ", 
              $CellContext`compileResult["StandardError"]]]; If[StringLength[
               $CellContext`compileResult["StandardOutput"]] > 0, 
             Print["Output: ", 
              StringTake[
               $CellContext`compileResult["StandardOutput"], 
               UpTo[1000]]]]; 
           Print["Revisa el archivo LaTeX en el editor para corregir \
errores"]; $CellContext`validatedPath]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "Global`CompiladorTex"|>, False]]], "Output",
 CellChangeTimes->{3.9664481057099943`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"7c48cdf0-329c-4278-b6a7-c7778ec0b006"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"contenido", "=", 
    RowBox[{"{", 
     RowBox[{"\"\<\\\\section{Introduccion}\>\"", 
      ",", "\"\<Este es un documento muy basico sin elementos especiales.\>\"",
       ",", "\"\<\>\"", ",", "\"\<\\\\section{Desarrollo}\>\"", 
      ",", "\"\<Aqu\[IAcute] se presenta el contenido principal del \
documento.\>\"", ",", "\"\<\>\"", 
      ",", "\"\<\\\\subsection{Punto Importante}\>\"", 
      ",", "\"\<Este subsection contiene informacion relevante.\>\"", 
      ",", "\"\<\>\"", ",", "\"\<\\\\section{Conclusion}\>\"", 
      ",", "\"\<En conclusion, este documento demuestra la configuracion \
minimalista.\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"path", "=", 
  RowBox[{"RenderToLatexDocument", "[", 
   RowBox[{"\"\<documento\>\"", ",", "contenido", ",", 
    RowBox[{"\"\<Title\>\"", "->", "\"\<Documento Simple\>\""}], ",", 
    RowBox[{"\"\<Author\>\"", "->", "\"\<Usuario\>\""}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", "path", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"path", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966447463460565*^9, 3.9664475013070908`*^9}, {
  3.966448158817163*^9, 3.9664482096966476`*^9}, {3.9664488587713127`*^9, 
  3.966448919540042*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"12bc412d-9403-41ca-9fae-92544c6de675"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/documento/documento.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.9664487644348297`*^9, 3.9664488310325327`*^9, {3.9664488659502897`*^9, 
   3.966448876314769*^9}, 3.9664489219831867`*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"6730c348-802f-4b19-a7b8-b18f8dcd9753"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448921985153*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"63bd9a89-7cfe-4578-929f-4268d8e93d0f"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448921985911*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"7649a37c-554c-4b5c-bc93-0d97f4a28fe2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489219867563`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"765d6006-84ff-473b-b4d6-7875de23ce46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXShop", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448921987322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"9415a071-9c95-41b4-ad96-c57b48e82300"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448922027721*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"f4f6e740-bb76-4ece-8ad8-465c0bc3e08b"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923037437*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"c16227df-cce3-44e5-8f0e-0a5ea9b98e74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/documento/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/documento/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923042699*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"7b187b60-f7d0-45d9-ada2-26b194650257"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"documento\"\>"}],
  SequenceForm["Archivo: ", "documento"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489230464783`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"2b4c05d6-3aa6-4cd2-b4cf-78551479ba4f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489234804993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"9b9a8974-1d3e-4ee0-b15e-96f984a14771"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/documento/documento.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/documento/documento.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923481309*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"08369edc-c1d2-46d2-bed5-da65bda17bd2"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/documento/documento.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9664487644348297`*^9, 3.9664488310325327`*^9, {3.9664488659502897`*^9, 
   3.966448876314769*^9}, 3.9664489235403547`*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"26d5e995-b7ef-49da-83bc-8936ff6deb27"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923542677*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"f943a275-6683-415b-a8f7-0013506afb6d"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923543312*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"4fbb0fa9-a0c0-4355-8fa2-b6ade4b467b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489235444098`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"1dce5358-e2fd-4c88-8721-dc060db43461"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923544923*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"e6303834-3b14-4eb3-99b5-cbfe096b89ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923545454*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"88db9c47-e96b-493a-93eb-4ca04e511f45"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448923603222*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"3cb2684a-b690-4442-9fd4-4a391c5f3a6c"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489246120853`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"8e5e1a42-8cb9-4045-b18d-cf2b3cb52427"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/documento/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/documento/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489246178627`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"b10fe9c8-7e6d-4628-944e-76ffc0c048a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"documento\"\>"}],
  SequenceForm["Archivo: ", "documento"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.966448924621325*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"81950724-8024-45ba-8ab8-369dd5dc2b78"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489250363827`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"80e36419-c821-4e4a-a414-7982edfb6f24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/documento/documento.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/documento/documento.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9664488310343437`*^9, {3.966448865953937*^9, 3.9664488763175364`*^9}, 
   3.9664489250372334`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[108]:=",ExpressionUUID->"debd79a7-e852-42ae-bf32-fb92dfc15aad"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/documento/documento.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9664487644348297`*^9, 3.9664488310325327`*^9, {3.9664488659502897`*^9, 
   3.966448876314769*^9}, 3.966448925049011*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"154c9fd3-0371-4ba5-91f8-e3d2e5440eea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compilando presentaci\[OAcute]n", "Section",
 CellChangeTimes->{{3.966445796397987*^9, 
  3.966445806480237*^9}},ExpressionUUID->"4ef228a3-13fb-4937-b07a-\
67e44ebf94c3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"contenido", "=", 
    RowBox[{"{", 
     RowBox[{"(*", 
      RowBox[{"Slide", " ", "de", " ", "introducci\[OAcute]n"}], "*)"}], 
     RowBox[{
      RowBox[{"BeamerSlide", "[", 
       RowBox[{"\"\<Introducci\[OAcute]n\>\"", 
        ",", "\"\<Esta presentaci\[OAcute]n cubre los puntos principales del \
tema.\>\""}], "]"}], ",", 
      RowBox[{"(*", 
       RowBox[{"Slide", " ", "con", " ", "lista"}], "*)"}], 
      RowBox[{"BeamerSlide", "[", 
       RowBox[{"\"\<Objetivos\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\\\\begin{itemize}\>\"", 
          ",", "\"\<\\\\item Objetivo principal\>\"", 
          ",", "\"\<\\\\item Objetivo secundario\>\"", 
          ",", "\"\<\\\\item Resultados esperados\>\"", 
          ",", "\"\<\\\\end{itemize}\>\""}], "}"}]}], "]"}], ",", 
      RowBox[{"(*", 
       RowBox[{"Slide", " ", "con", " ", "ecuaci\[OAcute]n"}], "*)"}], 
      RowBox[{"BeamerSlide", "[", 
       RowBox[{"\"\<Marco Te\[OAcute]rico\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<La ecuaci\[OAcute]n fundamental es:\>\"", 
          ",", "\"\<$$E = mc^2$$\>\"", 
          ",", "\"\<donde $E$ es energ\[IAcute]a, $m$ es masa y $c$ es \
velocidad de la luz.\>\""}], "}"}]}], "]"}], ",", 
      RowBox[{"(*", 
       RowBox[{"Slide", " ", "con", " ", "gr\[AAcute]fico"}], "*)"}], 
      RowBox[{"BeamerSlide", "[", 
       RowBox[{"\"\<Resultados\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<An\[AAcute]lisis de los datos:\>\"", ",", 
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{"Sin", "[", "x", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", 
              RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
            RowBox[{"PlotLabel", "->", "\"\<Funci\[OAcute]n Seno\>\""}]}], 
           "]"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"(*", 
       RowBox[{"Slide", " ", "de", " ", "conclusiones"}], "*)"}], 
      RowBox[{"BeamerSlide", "[", 
       RowBox[{"\"\<Conclusiones\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\\\\begin{enumerate}\>\"", 
          ",", "\"\<\\\\item Primera conclusi\[OAcute]n importante\>\"", 
          ",", "\"\<\\\\item Segunda conclusi\[OAcute]n relevante\>\"", 
          ",", "\"\<\\\\item Trabajo futuro\>\"", 
          ",", "\"\<\\\\end{enumerate}\>\""}], "}"}]}], "]"}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"path", "=", 
  RowBox[{"RenderToLatexBeamer", "[", 
   RowBox[{"\"\<presentacion\>\"", ",", "contenido", ",", 
    RowBox[{"\"\<Title\>\"", "->", "\"\<Mi Presentaci\[OAcute]n\>\""}], ",", 
    RowBox[{"\"\<Author\>\"", "->", "\"\<Tu Nombre\>\""}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", "path", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"path", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966447509348714*^9, 3.966447509695592*^9}, 
   3.966448224746499*^9, {3.96644896479361*^9, 3.966448972182996*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"798f682c-da42-42cb-98b0-ebee9a9a3d7e"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/presentacion_beamer/\
presentacion.tex\"\>"], "Output",
 CellChangeTimes->{3.966448973631563*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"8715dc79-a782-4faf-831f-16c96cff9083"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9664489736337976`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"cecbffae-bc3a-4209-9a16-c843d2899503"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966448973634344*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"a04cab13-ea84-41e6-b35d-40c8bbe8946d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448973635036*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"80ea0ed6-51c5-4882-86f2-d8afcf3e986e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXShop", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448973635497*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"c9acc637-e466-47ac-9bda-c6b1574add5e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966448973690281*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"082a1fbd-e9fc-4bcf-a688-e3e686b16672"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9664489746982927`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"541a56c9-d45c-4766-9165-c69d3a5a9726"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/presentacion_beamer/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/presentacion_beamer/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448974703401*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"cdd21de1-22d3-4cb2-b335-c130b314f0d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"presentacion\"\>"}],
  SequenceForm["Archivo: ", "presentacion"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9664489747078876`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"419a47e2-6813-44b3-85c3-f0113c998493"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966448975602819*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"b49391e4-4d6f-4083-94ba-1969b4bdc927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/presentacion_beamer/presentacion.\
pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/presentacion_beamer/presentacion.\
pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448975603735*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"b3443cd2-f767-43c9-b568-1fa86a6c8806"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/presentacion_beamer/\
presentacion.pdf\"\>"], "Output",
 CellChangeTimes->{3.966448975663782*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"8d2f06c1-802d-4897-a537-67d240018da8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448975666507*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"e2da048e-defe-4bef-b957-f54e7d6b43de"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966448975667221*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"86492a62-3fcb-4667-8038-f5626c91dd10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9664489756683817`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"af7027b8-eab3-40fe-879d-6b6cf216f298"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448975668909*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"7d8a4730-ef3b-479a-b3ba-6702d361ab3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9664489756694193`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"2e3a565b-9e3a-41e4-bb2a-80b2c0940734"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.96644897575082*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"0e5e93df-25d9-4c59-bd24-e0df704268cf"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9664489767590017`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"7b8da477-6049-47f8-824b-9ef9f64dc712"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/presentacion_beamer/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/presentacion_beamer/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448976764833*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"55d6f8a2-e640-4161-9fcd-6b8aa3fad787"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"presentacion\"\>"}],
  SequenceForm["Archivo: ", "presentacion"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448976768593*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"53a0d878-3b3a-4d50-b799-2324d1774864"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966448977591547*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"97f38cbe-3504-4b5b-bdf9-57682ee354d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/presentacion_beamer/presentacion.\
pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/presentacion_beamer/presentacion.\
pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966448977592455*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"d6102db7-68db-409e-bd74-028ad03fb37a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/presentacion_beamer/\
presentacion.pdf\"\>"], "Output",
 CellChangeTimes->{3.9664489776059093`*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"aa5eff6f-4455-4a8a-a0c5-33719cf9a24e"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1530, 685},
WindowMargins->{{Automatic, 0}, {42, Automatic}},
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b4d7c6c8-4053-4b48-9b4f-99c22feec2a7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 198, 3, 58, "Input",ExpressionUUID->"2e115df6-5abc-46e8-8d92-26eb4951c1d9"],
Cell[CellGroupData[{
Cell[799, 29, 1004, 30, 86, "Print",ExpressionUUID->"18854a9a-c2dc-437f-98a8-b8870d304360"],
Cell[1806, 61, 230, 4, 46, "Print",ExpressionUUID->"a07d32c7-b03c-4295-b65f-2c7e252a2308"],
Cell[2039, 67, 226, 4, 46, "Print",ExpressionUUID->"f9aa7dfc-dd50-4ddb-ae89-f1255688b84c"],
Cell[2268, 73, 469, 10, 46, "Print",ExpressionUUID->"3cd2bebd-0081-44ad-9a95-a04db536caa3"],
Cell[2740, 85, 506, 11, 46, "Print",ExpressionUUID->"04f28e80-f432-4c69-9c54-c0af55a45223"],
Cell[3249, 98, 473, 10, 46, "Print",ExpressionUUID->"bbf5d659-2afa-47bf-987a-02a5bcb0148f"],
Cell[3725, 110, 469, 10, 46, "Print",ExpressionUUID->"d7b44d30-dbe3-49a5-88a7-83697a28f79b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4243, 126, 482, 7, 136, "Subtitle",ExpressionUUID->"011f5e53-d3a6-4662-8d47-8ee4606d5bb9"],
Cell[CellGroupData[{
Cell[4750, 137, 207, 3, 58, "Input",ExpressionUUID->"405796b3-fb47-4472-b414-181c47bafa4a"],
Cell[4960, 142, 15716, 321, 1719, "Output",ExpressionUUID->"01a9ebdf-4b6d-49d9-a90e-0e7fb8d892f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20713, 468, 241, 4, 132, "Section",ExpressionUUID->"921fe881-7359-4444-92e7-3d64ef95dd56"],
Cell[CellGroupData[{
Cell[20979, 476, 213, 3, 58, "Input",ExpressionUUID->"83dc3943-62dd-4fe6-9bd4-8f00667c4b26"],
Cell[21195, 481, 27397, 586, 312, "Output",ExpressionUUID->"9ce6c6a7-4546-4701-aa79-c192111a40fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48629, 1072, 194, 3, 58, "Input",ExpressionUUID->"8dde7510-d0c6-4341-b70a-c9a17cbc10fc"],
Cell[48826, 1077, 151, 2, 66, "Output",ExpressionUUID->"5847b952-c481-4036-9d3c-b52a1d29d520"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49026, 1085, 211, 4, 132, "Section",ExpressionUUID->"5df9630f-bf40-470f-b7fb-f430b0553949"],
Cell[CellGroupData[{
Cell[49262, 1093, 208, 3, 58, "Input",ExpressionUUID->"fea48c15-0d67-4f84-93eb-f6a797f5b73e"],
Cell[49473, 1098, 14301, 337, 312, "Output",ExpressionUUID->"7274a262-bdf0-4a6c-a635-4d6c3d3a9fde"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63811, 1440, 213, 3, 58, "Input",ExpressionUUID->"42bfb7e8-eaf0-4a0c-bca4-e1d7bfd52300"],
Cell[CellGroupData[{
Cell[64049, 1447, 228, 4, 46, "Print",ExpressionUUID->"bd5f9d5d-079c-4e5a-ac5f-6ef50c88a183"],
Cell[64280, 1453, 228, 4, 46, "Print",ExpressionUUID->"f00d2e37-a805-4932-80e0-83128e57be6a"],
Cell[64511, 1459, 469, 10, 46, "Print",ExpressionUUID->"c6bf8c78-918b-4b90-b079-3aaf8c637bc4"],
Cell[64983, 1471, 506, 11, 46, "Print",ExpressionUUID->"f68fa79f-60b9-48ba-ac48-6bb8a9223a40"],
Cell[65492, 1484, 475, 10, 46, "Print",ExpressionUUID->"6ff4557c-250a-448b-a499-e640ae4463cc"],
Cell[65970, 1496, 471, 10, 46, "Print",ExpressionUUID->"93d01d61-2672-4acf-9b92-9f743cb26f4c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66502, 1513, 252, 4, 132, "Section",ExpressionUUID->"ed3493a0-5e21-44f6-8b88-1305050d215e"],
Cell[CellGroupData[{
Cell[66779, 1521, 202, 3, 58, "Input",ExpressionUUID->"eda81689-7d22-4990-b5d5-8565c61a0726"],
Cell[66984, 1526, 12551, 297, 312, "Output",ExpressionUUID->"44f2858d-abb4-4b90-b0a5-4cc2e640af08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79572, 1828, 183, 3, 58, "Input",ExpressionUUID->"04658ea3-b44d-4622-9e70-887920f48fd6"],
Cell[CellGroupData[{
Cell[79780, 1835, 239, 4, 46, "Print",ExpressionUUID->"1f07936e-3b4b-4eac-8e7b-a7e7b41a2e39"],
Cell[80022, 1841, 337, 8, 46, "Print",ExpressionUUID->"7043bbd8-6c70-4664-bb50-261f191a68c0"],
Cell[80362, 1851, 228, 4, 46, "Print",ExpressionUUID->"cc96bb9c-49c1-4c1d-be41-d8758e56992f"],
Cell[80593, 1857, 226, 4, 46, "Print",ExpressionUUID->"03c638af-3647-4eb9-9995-5231ce5dad2b"],
Cell[80822, 1863, 469, 10, 46, "Print",ExpressionUUID->"3be2c79f-704a-471e-8b54-af59fda4bdd7"],
Cell[81294, 1875, 506, 11, 46, "Print",ExpressionUUID->"ef354e1b-81cf-444b-892d-f47e85eda815"],
Cell[81803, 1888, 475, 10, 46, "Print",ExpressionUUID->"e0c04728-4f1f-48a2-b816-d2d6674fb0c8"],
Cell[82281, 1900, 469, 10, 46, "Print",ExpressionUUID->"7c5c967d-6105-4fde-beb2-0d76266aca91"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82811, 1917, 277, 5, 132, "Section",ExpressionUUID->"79f05bba-7ba8-4e77-8ee7-aff11e6e165b"],
Cell[CellGroupData[{
Cell[83113, 1926, 201, 3, 58, "Input",ExpressionUUID->"6eaa5950-2b34-4a65-8848-d72de1e2bd21"],
Cell[83317, 1931, 40836, 856, 812, "Output",ExpressionUUID->"7c48cdf0-329c-4278-b6a7-c7778ec0b006"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124190, 2792, 1493, 29, 467, "Input",ExpressionUUID->"12bc412d-9403-41ca-9fae-92544c6de675"],
Cell[125686, 2823, 329, 6, 66, "Output",ExpressionUUID->"6730c348-802f-4b19-a7b8-b18f8dcd9753"],
Cell[CellGroupData[{
Cell[126040, 2833, 502, 11, 46, "Print",ExpressionUUID->"63bd9a89-7cfe-4578-929f-4268d8e93d0f"],
Cell[126545, 2846, 293, 6, 46, "Print",ExpressionUUID->"7649a37c-554c-4b5c-bc93-0d97f4a28fe2"],
Cell[126841, 2854, 487, 11, 46, "Print",ExpressionUUID->"765d6006-84ff-473b-b4d6-7875de23ce46"],
Cell[127331, 2867, 488, 12, 46, "Print",ExpressionUUID->"9415a071-9c95-41b4-ad96-c57b48e82300"],
Cell[127822, 2881, 301, 6, 46, "Print",ExpressionUUID->"f4f6e740-bb76-4ece-8ad8-465c0bc3e08b"],
Cell[128126, 2889, 302, 6, 46, "Print",ExpressionUUID->"c16227df-cce3-44e5-8f0e-0a5ea9b98e74"],
Cell[128431, 2897, 540, 14, 46, "Print",ExpressionUUID->"7b187b60-f7d0-45d9-ada2-26b194650257"],
Cell[128974, 2913, 421, 10, 46, "Print",ExpressionUUID->"2b4c05d6-3aa6-4cd2-b4cf-78551479ba4f"],
Cell[129398, 2925, 302, 6, 46, "Print",ExpressionUUID->"9b9a8974-1d3e-4ee0-b15e-96f984a14771"],
Cell[129703, 2933, 548, 14, 46, "Print",ExpressionUUID->"08369edc-c1d2-46d2-bed5-da65bda17bd2"]
}, Open  ]],
Cell[130266, 2950, 329, 6, 66, "Output",ExpressionUUID->"26d5e995-b7ef-49da-83bc-8936ff6deb27"],
Cell[CellGroupData[{
Cell[130620, 2960, 502, 11, 46, "Print",ExpressionUUID->"f943a275-6683-415b-a8f7-0013506afb6d"],
Cell[131125, 2973, 293, 6, 46, "Print",ExpressionUUID->"4fbb0fa9-a0c0-4355-8fa2-b6ade4b467b6"],
Cell[131421, 2981, 487, 11, 46, "Print",ExpressionUUID->"1dce5358-e2fd-4c88-8721-dc060db43461"],
Cell[131911, 2994, 512, 11, 46, "Print",ExpressionUUID->"e6303834-3b14-4eb3-99b5-cbfe096b89ef"],
Cell[132426, 3007, 492, 12, 46, "Print",ExpressionUUID->"88db9c47-e96b-493a-93eb-4ca04e511f45"],
Cell[132921, 3021, 301, 6, 46, "Print",ExpressionUUID->"3cb2684a-b690-4442-9fd4-4a391c5f3a6c"],
Cell[133225, 3029, 304, 6, 46, "Print",ExpressionUUID->"8e5e1a42-8cb9-4045-b18d-cf2b3cb52427"],
Cell[133532, 3037, 542, 14, 46, "Print",ExpressionUUID->"b10fe9c8-7e6d-4628-944e-76ffc0c048a8"],
Cell[134077, 3053, 419, 10, 46, "Print",ExpressionUUID->"81950724-8024-45ba-8ab8-369dd5dc2b78"],
Cell[134499, 3065, 302, 6, 46, "Print",ExpressionUUID->"80e36419-c821-4e4a-a414-7982edfb6f24"],
Cell[134804, 3073, 550, 14, 46, "Print",ExpressionUUID->"debd79a7-e852-42ae-bf32-fb92dfc15aad"]
}, Open  ]],
Cell[135369, 3090, 327, 6, 66, "Output",ExpressionUUID->"154c9fd3-0371-4ba5-91f8-e3d2e5440eea"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135745, 3102, 176, 3, 132, "Section",ExpressionUUID->"4ef228a3-13fb-4937-b07a-67e44ebf94c3"],
Cell[CellGroupData[{
Cell[135946, 3109, 3183, 69, 905, "Input",ExpressionUUID->"798f682c-da42-42cb-98b0-ebee9a9a3d7e"],
Cell[139132, 3180, 237, 4, 66, "Output",ExpressionUUID->"8715dc79-a782-4faf-831f-16c96cff9083"],
Cell[CellGroupData[{
Cell[139394, 3188, 425, 9, 46, "Print",ExpressionUUID->"cecbffae-bc3a-4209-9a16-c843d2899503"],
Cell[139822, 3199, 214, 4, 46, "Print",ExpressionUUID->"a04cab13-ea84-41e6-b35d-40c8bbe8946d"],
Cell[140039, 3205, 406, 9, 46, "Print",ExpressionUUID->"80ea0ed6-51c5-4882-86f2-d8afcf3e986e"],
Cell[140448, 3216, 409, 10, 46, "Print",ExpressionUUID->"c9acc637-e466-47ac-9bda-c6b1574add5e"],
Cell[140860, 3228, 222, 4, 46, "Print",ExpressionUUID->"082a1fbd-e9fc-4bcf-a688-e3e686b16672"],
Cell[141085, 3234, 225, 4, 46, "Print",ExpressionUUID->"541a56c9-d45c-4766-9165-c69d3a5a9726"],
Cell[141313, 3240, 481, 12, 46, "Print",ExpressionUUID->"cdd21de1-22d3-4cb2-b335-c130b314f0d6"],
Cell[141797, 3254, 348, 8, 46, "Print",ExpressionUUID->"419a47e2-6813-44b3-85c3-f0113c998493"],
Cell[142148, 3264, 221, 4, 46, "Print",ExpressionUUID->"b49391e4-4d6f-4083-94ba-1969b4bdc927"],
Cell[142372, 3270, 499, 14, 46, "Print",ExpressionUUID->"b3443cd2-f767-43c9-b568-1fa86a6c8806"]
}, Open  ]],
Cell[142886, 3287, 237, 4, 66, "Output",ExpressionUUID->"8d2f06c1-802d-4897-a537-67d240018da8"],
Cell[CellGroupData[{
Cell[143148, 3295, 423, 9, 46, "Print",ExpressionUUID->"e2da048e-defe-4bef-b957-f54e7d6b43de"],
Cell[143574, 3306, 214, 4, 46, "Print",ExpressionUUID->"86492a62-3fcb-4667-8038-f5626c91dd10"],
Cell[143791, 3312, 408, 9, 46, "Print",ExpressionUUID->"af7027b8-eab3-40fe-879d-6b6cf216f298"],
Cell[144202, 3323, 433, 9, 46, "Print",ExpressionUUID->"7d8a4730-ef3b-479a-b3ba-6702d361ab3a"],
Cell[144638, 3334, 415, 10, 46, "Print",ExpressionUUID->"2e3a565b-9e3a-41e4-bb2a-80b2c0940734"],
Cell[145056, 3346, 221, 4, 46, "Print",ExpressionUUID->"0e5e93df-25d9-4c59-bd24-e0df704268cf"],
Cell[145280, 3352, 225, 4, 46, "Print",ExpressionUUID->"7b8da477-6049-47f8-824b-9ef9f64dc712"],
Cell[145508, 3358, 481, 12, 46, "Print",ExpressionUUID->"55d6f8a2-e640-4161-9fcd-6b8aa3fad787"],
Cell[145992, 3372, 346, 8, 46, "Print",ExpressionUUID->"53a0d878-3b3a-4d50-b799-2324d1774864"],
Cell[146341, 3382, 221, 4, 46, "Print",ExpressionUUID->"97f38cbe-3504-4b5b-bdf9-57682ee354d1"],
Cell[146565, 3388, 499, 14, 46, "Print",ExpressionUUID->"d6102db7-68db-409e-bd74-028ad03fb37a"]
}, Open  ]],
Cell[147079, 3405, 239, 4, 66, "Output",ExpressionUUID->"aa5eff6f-4455-4a8a-a0c5-33719cf9a24e"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

